/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_SESSION_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class InfoSession {
    private static Logger log = Logger.getLogger(InfoSession.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                ResultatInfo resultatInfo = new ResultatInfo("Obtenir des informations sur la session " + Long.toString(l) + " (C_GetSessionInfo)");
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                resultatInfo.setInfos(linkedHashMap);
                try {
                    CK_SESSION_INFO cK_SESSION_INFO = pKCS11.C_GetSessionInfo(l);
                    String string = "inconnu";
                    if (cK_SESSION_INFO != null) {
                        long l2 = cK_SESSION_INFO.state;
                        if (l2 == 0L) {
                            string = "RO public";
                        } else if (l2 == 1L) {
                            string = "RO utilisateur";
                        } else if (l2 == 2L) {
                            string = "RW public";
                        } else if (l2 == 4L) {
                            string = "RW SO";
                        } else if (l2 == 3L) {
                            string = "RW utilisateur";
                        }
                    } else {
                        log.error((Object)"L'operation a retourne des informations nulles");
                        throw new ExceptionTraitement(14, "L'op\u00e9ration a retourn\u00e9 des informations nulles");
                    }
                    linkedHashMap.put("Identifiant du slot sur lequel est ouverte la session", Long.toString(cK_SESSION_INFO.slotID));
                    linkedHashMap.put("Etat de la session", string);
                    linkedHashMap.put("Code d'erreur de la carte", Long.toString(cK_SESSION_INFO.ulDeviceError));
                    linkedHashMap.put("La session est en lecture seule", (cK_SESSION_INFO.flags & 2L) != 0L ? "Non" : "Oui");
                    linkedHashMap.put("La session est en lecture/\u00e9criture", (cK_SESSION_INFO.flags & 2L) != 0L ? "Oui" : "Non");
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultatInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                }
                return resultatInfo;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(14, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(14, "Une erreur inattendue est survenue");
        }
    }
}

